<?php
require_once "../includes/config.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) or empty($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Username dan password harus diisi']);
        exit;
    }

    // Check admin
    $stmt = $conn->prepare("SELECT id_admin, username, password, level FROM admin WHERE username = ?");
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            session_start();
            $_SESSION['user_id'] = $row['id_admin'];
            $_SESSION['username'] = $row['username'];
            $_SESSION['user_level'] = 'admin';
            echo json_encode(['status' => 'success', 'redirect' => '/pages/admin_dashboard.php']);
            exit;
        }
    }

    // Check user
    $stmt = $conn->prepare("SELECT id_user, username, password, level FROM user WHERE username = ?");
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            session_start();
            $_SESSION['user_id'] = $row['id_user'];
            $_SESSION['username'] = $row['username'];
            $_SESSION['user_level'] = 'user';
            echo json_encode(['status' => 'success', 'redirect' => '/pages/user_dashboard.php']);
            exit;
        }
    }

    echo json_encode(['status' => 'error', 'message' => 'Username atau password salah']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}
