<?php
require_once "../includes/config.php";

if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("HTTP/1.1 403 Forbidden");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../pages/input_kriteria.php");
    exit;
}

$action = $_POST['action'] ?? '';
$id_kriteria = $_POST['id_kriteria'] ?? null;
$nama_kriteria = $_POST['nama_kriteria'] ?? '';
$tipe = $_POST['tipe'] ?? 'Benefit';
$metode_pengukuran = $_POST['metode_pengukuran'] ?? '';
$nilai_bobot = $_POST['nilai_bobot'] ?? 0;

if ($action === 'add') {
    if (empty($nama_kriteria) || empty($metode_pengukuran) || $nilai_bobot <= 0) {
        die('Semua field harus diisi dengan benar');
    }
    $stmt = $conn->prepare("INSERT INTO kriteria (nama_kriteria, tipe, metode_pengukuran) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $nama_kriteria, $tipe, $metode_pengukuran);
    if ($stmt->execute()) {
        $insert_id = $stmt->insert_id;
        $stmt2 = $conn->prepare("INSERT INTO bobot (id_kriteria, nilai_bobot) VALUES (?, ?)");
        $stmt2->bind_param("id", $insert_id, $nilai_bobot);
        $stmt2->execute();
        $stmt2->close();
        header("Location: ../pages/input_kriteria.php?msg=add_success");
    } else {
        header("Location: ../pages/input_kriteria.php?msg=add_error");
    }
    exit;
} elseif ($action === 'update' && is_numeric($id_kriteria)) {
    if (empty($nama_kriteria) || empty($metode_pengukuran) || $nilai_bobot <= 0) {
        die('Semua field harus diisi dengan benar');
    }
    $stmt = $conn->prepare("UPDATE kriteria SET nama_kriteria = ?, tipe = ?, metode_pengukuran = ? WHERE id_kriteria = ?");
    $stmt->bind_param("sssi", $nama_kriteria, $tipe, $metode_pengukuran, $id_kriteria);
    if ($stmt->execute()) {
        $stmt2 = $conn->prepare("UPDATE bobot SET nilai_bobot = ? WHERE id_kriteria = ?");
        $stmt2->bind_param("di", $nilai_bobot, $id_kriteria);
        $stmt2->execute();
        $stmt2->close();
        header("Location: ../pages/input_kriteria.php?msg=update_success");
    } else {
        header("Location: ../pages/input_kriteria.php?msg=update_error");
    }
    exit;
} elseif ($action === 'delete' && is_numeric($id_kriteria)) {
    $stmt = $conn->prepare("DELETE FROM bobot WHERE id_kriteria = ?");
    $stmt->bind_param("i", $id_kriteria);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("DELETE FROM kriteria WHERE id_kriteria = ?");
    $stmt->bind_param("i", $id_kriteria);
    $stmt->execute();

    header("Location: ../pages/input_kriteria.php?msg=delete_success");
    exit;
} else {
    header("Location: ../pages/input_kriteria.php");
    exit;
}
