<?php
require_once "../includes/config.php";

if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("HTTP/1.1 403 Forbidden");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../pages/input_data.php");
    exit;
}

$action = $_POST['action'] ?? '';
$id_kayu = $_POST['id_kayu'] ?? null;
$nama_kayu = $_POST['nama_kayu'] ?? '';
$deskripsi = $_POST['deskripsi'] ?? '';

if ($action === 'add') {
    if (empty($nama_kayu)) {
        die('Nama kayu harus diisi');
    }
    $stmt = $conn->prepare("INSERT INTO kayu (nama_kayu, deskripsi) VALUES (?, ?)");
    $stmt->bind_param("ss", $nama_kayu, $deskripsi);
    if ($stmt->execute()) {
        header("Location: ../pages/input_data.php?msg=add_success");
    } else {
        header("Location: ../pages/input_data.php?msg=add_error");
    }
    exit;
} elseif ($action === 'update' && is_numeric($id_kayu)) {
    if (empty($nama_kayu)) {
        die('Nama kayu harus diisi');
    }
    $stmt = $conn->prepare("UPDATE kayu SET nama_kayu = ?, deskripsi = ? WHERE id_kayu = ?");
    $stmt->bind_param("ssi", $nama_kayu, $deskripsi, $id_kayu);
    if ($stmt->execute()) {
        header("Location: ../pages/input_data.php?msg=update_success");
    } else {
        header("Location: ../pages/input_data.php?msg=update_error");
    }
    exit;
} elseif ($action === 'delete' && is_numeric($id_kayu)) {
    $stmt = $conn->prepare("DELETE FROM kayu WHERE id_kayu = ?");
    $stmt->bind_param("i", $id_kayu);
    if ($stmt->execute()) {
        header("Location: ../pages/input_data.php?msg=delete_success");
    } else {
        header("Location: ../pages/input_data.php?msg=delete_error");
    }
    exit;
} else {
    header("Location: ../pages/input_data.php");
    exit;
}
