<?php
require_once "../includes/config.php";
if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'user') {
    header("Location: login.php");
    exit;
}
include "../includes/header.php";

// Fetch top 3 recommended wood from hasil_electre table
$top_rekomendasi = [];
$sql = "SELECT h.peringkat, k.nama_kayu 
        FROM hasil_electre h 
        JOIN kayu k ON h.id_kayu = k.id_kayu 
        ORDER BY h.peringkat ASC 
        LIMIT 3";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $top_rekomendasi[] = $row;
    }
}
?>

<h2>Dashboard User</h2>
<p>Selamat datang, <?php echo htmlspecialchars($_SESSION['username']); ?></p>

<h3>Top 3 Rekomendasi Kayu</h3>
<?php if (count($top_rekomendasi) > 0): ?>
    <table class="dashboard-table">
        <thead>
            <tr>
                <th>Peringkat</th>
                <th>Nama Kayu</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($top_rekomendasi as $rekom): ?>
            <tr>
                <td><?php echo htmlspecialchars($rekom['peringkat']); ?></td>
                <td><?php echo htmlspecialchars($rekom['nama_kayu']); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Tidak ada data rekomendasi tersedia.</p>
<?php endif; ?>

<ul>
    <li><a href="hasil_rekomendasi.php">Lihat Hasil Rekomendasi Kayu Lengkap</a></li>
</ul>

<?php
include "../includes/footer.php";
?>
