<?php
require_once "../includes/config.php";

if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// Fetch the ELECTRE results with details
$query = "
    SELECT h.id_hasil, k.nama_kayu, h.skor, h.peringkat 
    FROM hasil_electre h 
    JOIN kayu k ON h.id_kayu = k.id_kayu 
    ORDER BY h.peringkat ASC
";
$result = $conn->query($query);

include "../includes/header.php";
?>

<h2>Laporan Hasil Pemilihan Kayu Berdasarkan Metode ELECTRE</h2>
<p>Berikut adalah laporan hasil perhitungan dan peringkat kayu terbaik untuk digunakan di industri mebel Roda Barokah Jepara.</p>

<table border="1" cellpadding="8" cellspacing="0" >
    <thead>
        <tr>
            <th>Peringkat</th>
            <th>Nama Kayu</th>
            <th>Skor</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['peringkat']; ?></td>
                    <td><?php echo htmlspecialchars($row['nama_kayu']); ?></td>
                    <td><?php echo number_format($row['skor'], 4); ?></td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="3">Belum ada data hasil rekomendasi.</td></tr>
        <?php endif; ?>
    </tbody>
</table>

<?php
$result->free();
include "../includes/footer.php";
?>
