<?php
require_once "../includes/config.php";
if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$errors = [];
$success_msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $user_level = $_POST['user_level'] ?? '';

    if (empty($username)) {
        $errors[] = "Username is required.";
    }
    if (empty($password)) {
        $errors[] = "Password is required.";
    }
    if ($user_level !== 'admin' && $user_level !== 'user') {
        $errors[] = "User level must be 'admin' or 'user'.";
    }

    if (empty($errors)) {
        // Check if username already exists
        $stmt = $conn->prepare("SELECT id_user FROM user WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $errors[] = "Username already exists.";
        } else {
            // Insert new user
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO user (username, password, level) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $username, $hashed_password, $user_level);
            if ($stmt->execute()) {
                $success_msg = "User created successfully.";
            } else {
                $errors[] = "Error creating user: " . $conn->error;
            }
        }
        $stmt->close();
    }
}

include "../includes/header.php";
?>

<h2>Buat User Baru</h2>

<?php if ($success_msg): ?>
    <div class="success-msg"><?php echo htmlspecialchars($success_msg); ?></div>
<?php endif; ?>

<?php if ($errors): ?>
    <div class="error-msg">
        <ul>
            <?php foreach ($errors as $error): ?>
                <li><?php echo htmlspecialchars($error); ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<form method="post" action="input_user.php">
    <label for="username">Username:</label>
    <input type="text" id="username" name="username" required />

    <label for="password">Password:</label>
    <input type="password" id="password" name="password" required />

    <label for="user_level">User Level:</label>
    <select id="user_level" name="user_level" required>
        <option value="">-- Pilih Level User --</option>
        <option value="admin">Admin</option>
        <option value="user">User</option>
    </select>

    <input type="submit" value="Buat User" />
</form>

<?php
include "../includes/footer.php";
?>
