<?php
require_once "../includes/config.php";

if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$error = "";
$success = "";

// Handle form submission for add/update kriteria and bobot
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_kriteria = isset($_POST['id_kriteria']) ? intval($_POST['id_kriteria']) : 0;
    $nama_kriteria = trim($_POST['nama_kriteria']);
    $tipe = $_POST['tipe'] === 'Benefit' ? 'Benefit' : 'Cost';
    $metode_pengukuran = trim($_POST['metode_pengukuran']);
    $nilai_bobot = floatval($_POST['nilai_bobot']);

    if (empty($nama_kriteria) || empty($metode_pengukuran) || $nilai_bobot <= 0) {
        $error = "Semua field harus diisi dengan benar.";
    } else {
        if ($id_kriteria > 0) {
            // update kriteria
            $stmt = $conn->prepare("UPDATE kriteria SET nama_kriteria = ?, tipe = ?, metode_pengukuran = ? WHERE id_kriteria = ?");
            $stmt->bind_param("sssi", $nama_kriteria, $tipe, $metode_pengukuran, $id_kriteria);
            if ($stmt->execute()) {
                // update bobot
                $stmt2 = $conn->prepare("UPDATE bobot SET nilai_bobot = ? WHERE id_kriteria = ?");
                $stmt2->bind_param("di", $nilai_bobot, $id_kriteria);
                $stmt2->execute();
                $stmt2->close();

                $success = "Kriteria berhasil diperbarui.";
            } else {
                $error = "Gagal memperbarui kriteria.";
            }
            $stmt->close();
        } else {
            // insert new kriteria and bobot
            $stmt = $conn->prepare("INSERT INTO kriteria (nama_kriteria, tipe, metode_pengukuran) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $nama_kriteria, $tipe, $metode_pengukuran);
            if ($stmt->execute()) {
                $insert_id = $stmt->insert_id;
                $stmt2 = $conn->prepare("INSERT INTO bobot (id_kriteria, nilai_bobot) VALUES (?, ?)");
                $stmt2->bind_param("id", $insert_id, $nilai_bobot);
                $stmt2->execute();
                $stmt2->close();

                $success = "Kriteria dan bobot berhasil ditambahkan.";
            } else {
                $error = "Gagal menambahkan kriteria.";
            }
            $stmt->close();
        }
    }
}

// Handle delete
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $del_id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM kriteria WHERE id_kriteria = ?");
    $stmt->bind_param("i", $del_id);
    $stmt->execute();
    $stmt->close();
    header("Location: input_kriteria.php");
    exit;
}

// Edit mode load data
$edit_kriteria = null;
$edit_bobot = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $id_edit = $_GET['edit'];
    $stmt = $conn->prepare("SELECT k.id_kriteria, k.nama_kriteria, k.tipe, k.metode_pengukuran, b.nilai_bobot FROM kriteria k LEFT JOIN bobot b ON k.id_kriteria = b.id_kriteria WHERE k.id_kriteria = ?");
    $stmt->bind_param("i", $id_edit);
    $stmt->execute();
    
    // Use bind_result instead of get_result for compatibility
    $stmt->bind_result($id_kriteria, $nama_kriteria, $tipe, $metode_pengukuran, $nilai_bobot);
    
    if ($stmt->fetch()) {
        $edit_kriteria = [
            'id_kriteria' => $id_kriteria,
            'nama_kriteria' => $nama_kriteria,
            'tipe' => $tipe,
            'metode_pengukuran' => $metode_pengukuran,
            'nilai_bobot' => $nilai_bobot
        ];
    }
    $stmt->close();
}

$result = $conn->query("SELECT k.id_kriteria, k.nama_kriteria, k.tipe, k.metode_pengukuran, b.nilai_bobot
FROM kriteria k LEFT JOIN bobot b ON k.id_kriteria = b.id_kriteria ORDER BY k.id_kriteria ASC");

$kriteria_list = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $kriteria_list[] = $row;
    }
    $result->free();
}

include "../includes/header.php";
?>

<link rel="stylesheet" href="../assets/css/compact_kriteria.css">

<h2>Kelola Kriteria dan Bobot</h2>

<?php if ($error): ?>
    <div class="error-msg"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="success-msg"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="POST" action="" class="compact-form">
    <input type="hidden" name="id_kriteria" value="<?php echo $edit_kriteria ? $edit_kriteria['id_kriteria'] : ''; ?>">
    <div class="form-row">
        <label for="nama_kriteria">Nama Kriteria:</label>
        <input type="text" name="nama_kriteria" id="nama_kriteria" required value="<?php echo $edit_kriteria ? htmlspecialchars($edit_kriteria['nama_kriteria']) : ''; ?>">
    </div>
    <div class="form-row">
        <label for="tipe">Tipe Kriteria:</label>
        <select name="tipe" id="tipe" required>
            <option value="Benefit" <?php echo ($edit_kriteria && $edit_kriteria['tipe'] == 'Benefit') ? 'selected' : ''; ?>>Benefit</option>
            <option value="Cost" <?php echo ($edit_kriteria && $edit_kriteria['tipe'] == 'Cost') ? 'selected' : ''; ?>>Cost</option>
        </select>
    </div>
    <div class="form-row">
        <label for="metode_pengukuran">Metode Pengukuran:</label>
        <input type="text" name="metode_pengukuran" id="metode_pengukuran" required value="<?php echo $edit_kriteria ? htmlspecialchars($edit_kriteria['metode_pengukuran']) : ''; ?>">
    </div>
    <div class="form-row">
        <label for="nilai_bobot">Nilai Bobot:</label>
        <input type="number" step="0.01" min="0" max="1" name="nilai_bobot" id="nilai_bobot" required value="<?php echo $edit_kriteria ? htmlspecialchars($edit_kriteria['nilai_bobot']) : ''; ?>">
    </div>
    <div class="form-row form-actions">
        <button type="submit"><?php echo $edit_kriteria ? 'Update' : 'Tambah'; ?></button>
        <?php if ($edit_kriteria): ?>
            <a href="input_kriteria.php" class="cancel-link">Batal</a>
        <?php endif; ?>
    </div>
</form>

<hr>

<h3>Daftar Kriteria</h3>
<table class="compact-table" border="1" cellpadding="8" cellspacing="0" >
    <thead>
        <tr>
            <th>ID</th>
            <th>Nama Kriteria</th>
            <th>Tipe</th>
            <th>Metode Pengukuran</th>
            <th>Bobot</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
    <?php if (count($kriteria_list) > 0): ?>
        <?php foreach ($kriteria_list as $k): ?>
            <tr>
                <td><?php echo $k['id_kriteria']; ?></td>
                <td><?php echo htmlspecialchars($k['nama_kriteria']); ?></td>
                <td><?php echo $k['tipe']; ?></td>
                <td><?php echo htmlspecialchars($k['metode_pengukuran']); ?></td>
                <td><?php echo $k['nilai_bobot']; ?></td>
                <td>
                    <a href="input_kriteria.php?edit=<?php echo $k['id_kriteria']; ?>">Edit</a> |
                    <a href="input_kriteria.php?delete=<?php echo $k['id_kriteria']; ?>" onclick="return confirm('Yakin ingin menghapus kriteria ini?');">Hapus</a>
                </td>
            </tr>
        <?php endforeach;?>
    <?php else: ?>
        <tr><td colspan="6">Belum ada data kriteria.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

<?php
include "../includes/footer.php";
?>
