<?php
/* Halaman utama */
require_once "../includes/config.php";
include "../includes/header.php";
?>

<style>
  .welcome-section {
    background-color: #f5f5f5;
    padding: 30px;
    border-radius: 8px;
    text-align: center;
    margin-bottom: 20px;
  }
  .welcome-section h1 {
    color: #2c3e50;
    font-size: 2.5em;
    margin-bottom: 10px;
  }
  .welcome-section p {
    font-size: 1.2em;
    color: #34495e;
  }
  .quick-links {
    display: flex;
    justify-content: center;
    gap: 20px;
    margin-top: 25px;
  }
  .quick-links a {
    background-color: #2980b9;
    color: white;
    padding: 12px 25px;
    border-radius: 5px;
    text-decoration: none;
    font-weight: bold;
    transition: background-color 0.3s ease;
  }
  .quick-links a:hover {
    background-color: #3498db;
  }
  .greeting {
    font-size: 1.3em;
    color: #27ae60;
    margin-bottom: 15px;
  }
  .electre-info {
    font-size: 1em;
    color: #7f8c8d;
    max-width: 600px;
    margin: 0 auto 30px auto;
  }
</style>

<div class="welcome-section">
  <?php if (isset($_SESSION['username'])): ?>
    <div class="greeting">Halo, <?= htmlspecialchars($_SESSION['username']) ?>! Selamat datang kembali di Sistem Pendukung Keputusan Kayu Berkualitas.</div>
  <?php endif; ?>
  <h1>Selamat datang di Sistem Pendukung Keputusan Pemilihan Kayu Berkualitas</h1>
  <p>Aplikasi ini membantu memilih kayu terbaik menggunakan metode ELECTRE untuk industri mebel Roda Barokah Jepara.</p>
  <div class="electre-info" title="ELECTRE adalah metode pengambilan keputusan yang menggunakan konsep perbandingan berpasangan untuk memilih alternatif terbaik.">
    Metode ELECTRE membantu Anda membuat keputusan yang lebih tepat dan objektif dalam memilih kayu berkualitas.
  </div>
  <div class="quick-links">
    <a href="input_data.php">Input Data Kayu</a>
    <a href="laporan.php">Laporan</a>
    <?php if (!isset($_SESSION['user_level'])): ?>
      <a href="login.php">Login</a>
    <?php endif; ?>
  </div>
</div>

<?php
include "../includes/footer.php";
?>
