<?php
require_once "../includes/config.php";
if (!isset($_SESSION['user_level']) || $_SESSION['user_level'] !== 'admin') {
    header("Location: login.php");
    exit;
}
include "../includes/header.php";
?>
<h2>Dashboard Admin</h2>
<p>Selamat datang, <?php echo htmlspecialchars($_SESSION['username']); ?></p>

<?php
// Fetch summary counts
$kayu_count = 0;
$kriteria_count = 0;
$rekomendasi_count = 0;

if ($conn) {
    $result = $conn->query("SELECT COUNT(*) AS count FROM kayu");
    if ($result) {
        $row = $result->fetch_assoc();
        $kayu_count = $row['count'];
    }

    $result = $conn->query("SELECT COUNT(*) AS count FROM kriteria");
    if ($result) {
        $row = $result->fetch_assoc();
        $kriteria_count = $row['count'];
    }

    $result = $conn->query("SELECT COUNT(*) AS count FROM hasil_electre");
    if ($result) {
        $row = $result->fetch_assoc();
        $rekomendasi_count = $row['count'];
    }
} else {
    echo "<p>Error: Database connection not established.</p>";
}
?>

<div class="dashboard-cards">
    <div class="card">
        <h3>Total Data Kayu</h3>
        <p><?php echo $kayu_count; ?></p>
        <a href="input_data.php" class="btn">Kelola Data Kayu</a>
    </div>
    <div class="card">
        <h3>Total Kriteria</h3>
        <p><?php echo $kriteria_count; ?></p>
        <a href="input_kriteria.php" class="btn">Kelola Kriteria & Bobot</a>
    </div>
    <div class="card">
        <h3>Laporan</h3>
        <p>laporan pemilihan kayu</p>
        <a href="laporan.php" class="btn">Laporan</a>
    </div>
    <div class="card">
        <h3>Buat User Baru</h3>
        <p>Tambah admin atau user baru</p>
        <a href="input_user.php" class="btn">Buat User</a>
    </div>
</div>
<?php
include "../includes/footer.php";
?>
