<?php
require_once "includes/config.php";

echo "<h1>Diagnostic Database - Sistem SPK Kayu</h1>";
echo "<h2>1. Cek Koneksi Database</h2>";

// Cek koneksi database
if ($conn->connect_error) {
    echo "<p style='color:red'>❌ Koneksi Gagal: " . $conn->connect_error . "</p>";
} else {
    echo "<p style='color:green'>✅ Koneksi Berhasil</p>";
    echo "<p>Host: " . $conn->host_info . "</p>";
    echo "<p>Server Version: " . $conn->server_info . "</p>";
}

echo "<h2>2. Cek Struktur Tabel Kayu</h2>";

// Cek apakah tabel kayu ada
$table_check = $conn->query("SHOW TABLES LIKE 'kayu'");
if ($table_check->num_rows > 0) {
    echo "<p style='color:green'>✅ Tabel kayu ditemukan</p>";
    
    // Cek struktur tabel
    $result = $conn->query("DESCRIBE kayu");
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Cek jumlah data
    $count_result = $conn->query("SELECT COUNT(*) as total FROM kayu");
    $count = $count_result->fetch_assoc();
    echo "<p>Total data kayu: " . $count['total'] . "</p>";
    
} else {
    echo "<p style='color:red'>❌ Tabel kayu tidak ditemukan</p>";
}

echo "<h2>3. Test Insert Data</h2>";

// Test insert data dummy
try {
    $test_data = [
        'nama_kayu' => 'Test Kayu',
        'kekuatan_kayu' => 70.50,
        'kepadatan_kayu' => 650.00,
        'kadar_air' => 15.00,
        'harga' => 5000000.00
    ];
    
    $stmt = $conn->prepare("INSERT INTO kayu (nama_kayu, kekuatan_kayu, kepadatan_kayu, kadar_air, harga) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sdddd", 
        $test_data['nama_kayu'],
        $test_data['kekuatan_kayu'],
        $test_data['kepadatan_kayu'],
        $test_data['kadar_air'],
        $test_data['harga']
    );
    
    if ($stmt->execute()) {
        echo "<p style='color:green'>✅ Test insert berhasil - ID: " . $stmt->insert_id . "</p>";
        // Hapus data test
        $conn->query("DELETE FROM kayu WHERE nama_kayu = 'Test Kayu'");
    } else {
        echo "<p style='color:red'>❌ Test insert gagal: " . $stmt->error . "</p>";
    }
    $stmt->close();
    
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<h2>4. Cek Error Log</h2>";
echo "<pre>";
print_r(error_get_last());
echo "</pre>";

echo "<h2>5. Informasi PHP</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>MySQLi Extension: " . (extension_loaded('mysqli') ? 'Enabled' : 'Disabled') . "</p>";

$conn->close();
?>
<p><a href="pages/input_data.php">Kembali ke Form Input Data Kayu</a></p>
