-- Database: spk_kayu
CREATE DATABASE IF NOT EXISTS spk_kayu;
USE spk_kayu;

-- Table Admin
CREATE TABLE IF NOT EXISTS admin (
    id_admin INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    level VARCHAR(20) NOT NULL DEFAULT 'admin'
);

-- Table User
CREATE TABLE IF NOT EXISTS user (
    id_user INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    level VARCHAR(20) NOT NULL DEFAULT 'user'
);

-- Table Kayu
CREATE TABLE IF NOT EXISTS kayu (
    id_kayu INT AUTO_INCREMENT PRIMARY KEY,
    nama_kayu VARCHAR(100) NOT NULL,
    deskripsi TEXT
);

-- Table Kriteria
CREATE TABLE IF NOT EXISTS kriteria (
    id_kriteria INT AUTO_INCREMENT PRIMARY KEY,
    nama_kriteria VARCHAR(100) NOT NULL,
    tipe ENUM('Benefit', 'Cost') NOT NULL,
    metode_pengukuran VARCHAR(100) NOT NULL
);

-- Table Bobot
CREATE TABLE IF NOT EXISTS bobot (
    id_bobot INT AUTO_INCREMENT PRIMARY KEY,
    id_kriteria INT NOT NULL,
    nilai_bobot DECIMAL(5,2) NOT NULL,
    FOREIGN KEY (id_kriteria) REFERENCES kriteria(id_kriteria) ON DELETE CASCADE
);

-- Table Penilaian
CREATE TABLE IF NOT EXISTS penilaian (
    id_penilaian INT AUTO_INCREMENT PRIMARY KEY,
    id_kayu INT NOT NULL,
    id_kriteria INT NOT NULL,
    nilai DECIMAL(10,2) NOT NULL,
    FOREIGN KEY (id_kayu) REFERENCES kayu(id_kayu) ON DELETE CASCADE,
    FOREIGN KEY (id_kriteria) REFERENCES kriteria(id_kriteria) ON DELETE CASCADE
);

-- Table Hasil_Electre
CREATE TABLE IF NOT EXISTS hasil_electre (
    id_hasil INT AUTO_INCREMENT PRIMARY KEY,
    id_kayu INT NOT NULL,
    skor DECIMAL(10,4) NOT NULL,
    peringkat INT NOT NULL,
    FOREIGN KEY (id_kayu) REFERENCES kayu(id_kayu) ON DELETE CASCADE
);

-- Insert Default Admin (password: admin123 hashed)
INSERT INTO admin (username, password, level) VALUES
('admin', '$2y$10$XDyqdA6YBCAZxZHPKfBVVusP5MNJ5q8v5pVQGpz5Twh77lzLCV2tK', 'admin');

-- Insert Default User (password: user123 hashed)
INSERT INTO user (username, password, level) VALUES
('user', '$2y$10$QwMCXkVTOddQkXZjH8ji.eApVbXIOwFsNvh6m2lEPJS8J/eDU6sce', 'user');

-- Insert initial kayu data
INSERT INTO kayu (nama_kayu, deskripsi) VALUES
('Kayu Meranti', 'Kayu keras meranti, umum digunakan untuk mebel.'),
('Kayu Jati', 'Kayu jati berkualitas tinggi, tahan lama dan kuat.'),
('Kayu Sengon', 'Kayu ringan, kering dan mudah diolah.'),
('Kayu Mahoni', 'Kayu mahal, warna merah dan keras.'),
('Kayu Pinus', 'Kayu lunak, cepat tumbuh dan mudah didapat.'),
('Kayu Ulin', 'Kayu terkeras dan tahan lama.'),
('Kayu Balau', 'Kayu kuat dengan warna gelap.'),
('Kayu Albasia', 'Kayu ringan dan murah.'),
('Kayu Ramin', 'Kayu sedang, umum dipakai.'),
('Kayu Kayu Legi', 'Jenis kayu lokal berkualitas.'),
('Kayu Damar', 'Kayu sedang keras dan tahan.'),
('Kayu Balsa', 'Kayu sangat ringan dan lembut.'),
('Kayu Tembaga', 'Kayu kuat dan tahan lama.'),
('Kayu Pecan', 'Kayu keras dengan warna coklat.'),
('Kayu Bangkirai', 'Kayu keras dengan warna kuning kekuningan.');

-- Insert initial kriteria data
INSERT INTO kriteria (nama_kriteria, tipe, metode_pengukuran) VALUES
('Kekuatan Kayu', 'Benefit', 'MPa'),
('Kepadatan Kayu', 'Benefit', 'kg/m³'),
('Kadar Air', 'Cost', '%'),
('Harga', 'Cost', 'IDR/m³');

-- Insert bobot data corresponding to kriteria
-- Bobot: Kekuatan 0.40, Kepadatan 0.30, Kadar Air 0.15, Harga 0.15
INSERT INTO bobot (id_kriteria, nilai_bobot) VALUES
(1, 0.40),
(2, 0.30),
(3, 0.15),
(4, 0.15);
